/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.srvutil;

import com.ibm.hsc.auiml.databeans.sfp.srvutil.ASMInterfaceBean;
import com.ibm.hsc.auiml.databeans.sfp.srvutil.ServiceUtilConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.ServiceUtilitiesTarget;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LaunchASMTasklet
extends TargetedTasklet
implements ServiceUtilConstants {
    private static final String TRACE_MASKD = "JASMTSKD";
    private static final String TRACE_MASKF = "JASMTSKF";
    private static final String TRACE_MASKT = "JASMTSKT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.srvutil.ASMInterface";
    private static final String INITIAL_PANEL = "ASMMainPanel";
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final short ERRID_0030 = 48;
    private static final short ERRID_0031 = 49;
    private static final short ERRID_0032 = 50;
    private static final short ERRID_0033 = 51;
    private static final short ERRID_0034 = 52;
    private static final short ERRID_0035 = 53;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -128, "SFPUtilASM");

    public LaunchASMTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> LaunchASMTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> LaunchASMTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"-> LaunchASMTasklet.isInitialRequest()");
            ASMInterfaceBean aSMInterfaceBean = new ASMInterfaceBean();
            aSMInterfaceBean.setBeanName("ASMInterfaceBean");
            Target[] targetArray = this.getSelectedTargets();
            String string = targetArray[0].getName().toString();
            String string2 = null;
            Object object = ((ServiceUtilitiesTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec) {
                string2 = ((PICec)object).getUserDefinedName();
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system name is: " + string));
                Trace.trace((String)TRACE_MASKF, (Object)("-- userDefinedName is: " + string2));
                if (string != null && string.length() != 0) {
                    aSMInterfaceBean.setSelectedSystem(string);
                } else {
                    aSMInterfaceBean.setSelectedSystem("Unknown");
                }
                try {
                    this.getPrimaryFSP(string2, aSMInterfaceBean);
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)aSMInterfaceBean);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKD, (Object)("-- exception during initial service request, e is " + exception));
                    new AusMicrocodeLog(_logInfo, 49, exception).writeEntry(null);
                    String string3 = exception.getMessage().equals("CIMNullClient") ? "0242" : (exception instanceof UnknownHostException ? "0241" : (exception instanceof PIHscClientException ? "0243" : "0245"));
                    SFPUtil.showSFPErrorMessageBox(string3, (PanelTasklet)this);
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)aSMInterfaceBean);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKF, (Object)"<- LaunchASMTasklet.isInitialRequest()");
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)("taskletRequest.getData(event): " + panelTaskletRequest.getData("event") + "."));
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
                panelTaskletResponse.dispose();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Some taskletRequest other than Cancel is pending.");
                String string = (String)panelTaskletRequest.getData("event");
                Trace.trace((String)TRACE_MASKF, (Object)("event is " + string));
                if (string.equals("OKButton")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"OK button found tasklet side.");
                    String string4 = (String)panelTaskletRequest.getData("Exception");
                    Trace.trace((String)TRACE_MASKF, (Object)("rcValue is <" + string4 + ">"));
                    if (string4 != null) {
                        if (!string4.equals("0")) {
                            new AusMicrocodeLog(_logInfo, 53).writeEntry(null);
                            SFPUtil.showSFPErrorMessageBox("0181", (PanelTasklet)this);
                        } else {
                            Trace.trace((String)TRACE_MASKF, (Object)"no errors lanching client browser");
                        }
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"rcValue returned null from client");
                    }
                    panelTaskletResponse.terminate();
                } else {
                    Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to LaunchASMTasklet.");
                }
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- LaunchASMTasklet.service()");
    }

    public void getPrimaryFSP(String string, ASMInterfaceBean aSMInterfaceBean) throws Exception {
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> LaunchASMTasklet.getPrimaryFSP()");
            try {
                PIHSCCECClient pIHSCCECClient = this.createCECClient(string);
                if (pIHSCCECClient != null) {
                    try {
                        this.getSelCecFspIpAddr(pIHSCCECClient, aSMInterfaceBean);
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getSelCecFspIpAddr() completed successfully");
                        break block5;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getSelCecFspIpAddr(), exception is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        new AusMicrocodeLog(_logInfo, 50, exception).writeEntry(null);
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- could not create the CEC CIM client");
                new AusMicrocodeLog(_logInfo, 51).writeEntry(null);
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                new AusMicrocodeLog(_logInfo, 52, exception).writeEntry(null);
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- LaunchASMTasklet.getPrimaryFSP()");
    }

    protected void getSelCecFspIpAddr(PIHSCCECClient pIHSCCECClient, ASMInterfaceBean aSMInterfaceBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> LaunchASMTasklet.getSelCecFspIpAddr()");
        PICECDataBean pICECDataBean = null;
        String string = null;
        try {
            String[] stringArray = new String[]{"ipaddr"};
            pICECDataBean = pIHSCCECClient.getCECDataBean(stringArray);
            if (pICECDataBean != null) {
                string = pICECDataBean.getIpAddress();
                Trace.trace((String)TRACE_MASKF, (Object)("-- returned ipaddr is: <" + string + ">"));
                if (string != null && string.length() > 0) {
                    aSMInterfaceBean.setFSP_IPaddr(string);
                } else {
                    aSMInterfaceBean.setFSP_IPaddr("Not Available");
                }
            } else {
                aSMInterfaceBean.setFSP_IPaddr("Not Available");
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getSelCecFspIpAddr() cmd. Exception is: " + exception));
            aSMInterfaceBean.setFSP_IPaddr("Not Available");
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- LaunchASMTasklet.getSelCecFspIpAddr()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> LaunchASMTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 48, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- LaunchASMTasklet.logException()");
    }
}

